#!/bin/bash

echo "Информационно-управляющая система Цифровая дерматоскопия"
echo "РОССИЙСКОЕ ОБЩЕСТВО ДЕРМАТОСКОПИИ"
echo

export PATH=$PATH:/usr/sbin:/sbin
source /etc/os-release

RDS_OS=$ID
[[ "${VERSION_ID}" =~ ^[0-9]+ ]]
RDS_OS_MAJOR="${BASH_REMATCH[0]}"

RDS_ARCH="$(uname -m)"
RDS_PKG="apt-get -qq install -y"
RDS_UPDATE=false
RDS_LOG=install.log
RDS_USER=$USERNAME

while getopts "us:v:" opt
do
    case $opt in
	u) RDS_UPDATE=true; echo " * Обновление";;
	s) RDS_OS=$OPTARG; RDS_OS_MAJOR="default";;
	v) RDS_OS_MAJOR=$OPTARG;;
    esac
done

function rds_dep {
    ${RDS_PKG} $1 2>>${RDS_LOG}
    if [ $? = "0" ]
    then
	echo " * $1"
    else
	echo " x $1"
    fi
}

echo " * Архитектура: $RDS_ARCH"
case $RDS_ARCH in
aarch64)
;;
x86_64)
;;
*)
echo "Архитектура не поддерживается."
exit
;;
esac

echo " * Операционная система: $RDS_OS"
echo " * Версия: $RDS_OS_MAJOR"
case $RDS_OS in
altlinux)
    RDS_DEP=("libatomic1" "libomp" "libjpeg" "libgtkmm3")
    RDS_USER=$LOGNAME
;;
debian)
    RDS_DEP=("libatomic1" "libomp5" "^libjpeg[0-9]+-turbo$" "^libgtkmm-3.0-[0-9]+[v]?[0-9]*$")
;;
ubuntu)
    RDS_DEP=("libatomic1" "libomp5" "libjpeg-turbo8" "^libgtkmm-3.0-[0-9]+[v]?[0-9]*$")
;;
linuxmint)
    RDS_DEP=("libatomic1" "libomp5" "libjpeg-turbo8" "^libgtkmm-3.0-[0-9]+[v]?[0-9]*$")
;;
rosa)
    RDS_PKG="dnf -qy install"
    RDS_DEP=("libatomic" "^lib64gtkmm3.[0-9_]+$")
;;
astra)
    RDS_DEP=("libatomic1" "libomp5" "^libjpeg[0-9]+-turbo$" "^libgtkmm-3.0-[0-9]+[v]?[0-9]*$")
;;
rocky)
    RDS_PKG="dnf -qy install"
    RDS_DEP=("libatomic" "libomp")
;;
redos)
    RDS_PKG="yum -q -y install"
    RDS_DEP=("libatomic" "gtkmm30")
    export PATH=$(dirname "$0")/2caf:$PATH
;;
*)
echo "Операционная система не поддерживается."
exit
;;
esac

echo " * Пользователь: ${RDS_USER}"
if [ "$(id -u)" != "0" ]; then
    echo
    echo "Для установки нужны права суперпользователя."
    exit
fi

RDS_SERIAL=`lsusb -d 10c4:`
RDS_MVS=`lsusb -d 2bdf:`
RDS_IDS=`lsusb -d 2caf:`
RDS_IDSOLD=`lsusb -d 1409:`
RDS_TTY=""

RDS_MODULE="cp210x"
RDS_MOD=$(find /lib/modules -type f -name ${RDS_MODULE}.ko\*)
RDS_KMOD=$(cat /lib/modules/$(uname -r)/modules.builtin | grep ${RDS_MODULE}.ko)

if [ -z "$RDS_MOD" ] && [ -z "$RDS_KMOD" ]
then
    echo  " * Модуль ядра $RDS_MODULE не найден"
    RDS_MOD="?"
else
    echo  " * Модуль ядра $RDS_MODULE найден"
    RDS_MOD=""
fi

echo """
УСЛОВИЯ ЛИЦЕНЗИИ НА ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ
Настоящие условия лицензии являются соглашением между пользователем и разработ-
чиком программного обеспечение (ПО). Используя ПО,  Вы тем самым подтверждаете
свое  согласие  соблюдать  данные условия.  Если  Вы  не  согласны с условиями
лицензии, не используйте это ПО.  При  соблюдении  данных  условий лицензии Вы
получаете право устанавливать и использовать ПО на неограниченном числе компью-
теров.  Настоящее  ПО  предназначено для неограниченного круга пользователей в
целях  взаимной помощи и обмена опытом  в области дерматоскопии.  ПО позволяет
загружать изображения в формате JPG, полученные с любых устройств,  включая мо-
бильные телефоны и фотоаппараты.  Некоторые  функции ПО  зависят от  сторонних
внешних компьютерных программ (Служб),  доступных через Интернет.  Разработчик
ПО не гарантирует доступность  этих Служб.  Доступ к некоторым Службам требует
ввода и передачи персональных данных (адреса электронной почты) для идентифика-
ции  пользователя.  Используя  эти  функции,  Вы  выражаете  свое согласие  на
передачу,  обработку  и  хранение данных, в том числе,  полученных изображений,
в этих компьютерных системах  на территории России.  Вы соглашаетесь, что пере-
данные данные  могут быть использованы  в  научно-исследовательских и просвети-
тельских целях.  Данные могут храниться до момента обращения к разработчикам и
администраторам Служб  для удаления этой информации.  ПО  не предназначено для
замены медицинского осмотра  или  медицинского заключения. Функция выбора меди-
цинского специалиста по результатам  удаленной обработки изображения  доступна
при самостоятельном применении программы в рамках формирования  ответственного
отношения к личному здоровью.  Ни под каким предлогом результат автоматической
обработки изображений не должен влиять на принятие клинического решения.
Использование ПО осуществляется безвозмездно. Вы не имеете права продавать это
программное обеспечение. ПО предоставляется в том виде, в котором осуществляет-
ся его распространение,  без принятия на себя каких-либо гарантийных обязатель-
ств, как выраженных явно,  так и подразумеваемых,  в том числе подразумеваемых
гарантий качества, пригодности для конкретных целей,  целостности данных, нена-
рушения прав на  интеллектуальную собственность  и  доступности внешних систем,
обеспечивающих  работу  ПО.  Весь риск,  касающийся качества и работы ПО несет
пользователь.  В случае если в  ПО  будут обнаружены  недостатки,  все расходы, 
связанные  с  обслуживанием, восстановлением или исправлением оборудования или
программного обеспечения несет пользователь.

На время установки подключите дерматоскоп, если он имеется, а также
обязательно отключите другие USB-UART устройства /dev/ttyUSB*
"""

read -p "Согласиться с условиями лицензии и продолжить установку? yn " yn
case $yn in
    [Yy]* ) echo;;
    [Nn]* ) exit;;
esac

for i in 0 1 2 3 4
do
    if [ -e /dev/ttyUSB${i} ]
    then
	if [ -z "${RDS_TTY}" ]
	then
	    RDS_TTY="/dev/ttyUSB${i}"
	else
	    RDS_TTY="multiple"
	    break
	fi
    fi
done

if [ -z "$RDS_MVS$RDS_IDS$RDS_IDSOLD" ]
    then
    echo " x дерматоскоп не обнаружен, не будет настроен"
else
    if [ -z "$RDS_SERIAL" ]
    then
	echo " * Дерматоскоп: РДС-2${RDS_MOD}"
    else
	if [ "${RDS_TTY}" = "multiple" ]
	then
	    echo " x несколько usb tty, дерматоскоп не будет настроен"
	elif [ ! -z RDS_TTY ]
	then
	    echo " * Дерматоскоп: настройка РДС-2 ${RDS_TTY}"
	    stty -F $RDS_TTY -crtscts
	    usermod -a -G dialout ${RDS_USER}
	fi
    fi
    
fi


echo
echo "Установка ИУС Цифровая дерматоскопия..."
echo

if [ ! `which wget 2>/dev/null` ]
then
    rds_dep "wget"
fi

for dep_name in "${RDS_DEP[@]}"
do
    rds_dep $dep_name
done

if [ $RDS_UPDATE = true ] || [ ! -f /usr/bin/dermatoscopy ]
then
    echo " * загрузка файлов программы"
    wget -q --spider --no-check-certificate https://www.dermatology.ru
    if [ $? -eq 0 ]
    then
	wget -q -N -nd --no-check-certificate https://www.dermatology.ru/rds/${RDS_ARCH}/${RDS_OS}/${RDS_OS_MAJOR}/dermatoscopy.gz -P $(dirname "$0") >/dev/null 2>${RDS_LOG}
	if [ $? -eq 0 ]
	then
	    gunzip $(dirname "$0")/dermatoscopy.gz
	    mv -f $(dirname "$0")/dermatoscopy /usr/bin/dermatoscopy
	    chmod a+x /usr/bin/dermatoscopy
	    
	    wget -q -N -nd --no-check-certificate https://www.dermatology.ru/rds/dermatoscopy.xpm  -P /usr/share/icons >/dev/null 2>>${RDS_LOG}
	    if [ -d /usr/share/applications ]; then
		wget -q -N -nd --no-check-certificate https://www.dermatology.ru/rds/dermatoscopy.desktop -P /usr/share/applications >/dev/null 2>>${RDS_LOG}
		echo " * значок в Приложениях-Наука или Прочее"
	    fi
	else
	    echo " x нет файла для этой версии дистрибутива, попробуйте с ключем -v default"
	    echo
	    exit
	fi
    else
	echo " x нет доступа к dermatology.ru"
    fi
else
	echo " x программа уже была установлена. Используйте ключ -u для обновления"
fi

if [ ! -z "$RDS_IDS$RDS_IDSOLD" ]
then
    /bin/bash $(dirname "$0")/2caf/install.sh full
else
    /bin/bash $(dirname "$0")/2caf/install.sh
fi
/bin/bash $(dirname "$0")/2bdf/install.sh

echo
echo "Готово."
echo "Запуск программы по команде dermatoscopy"

