#!/bin/bash

export PATH=$PATH:/usr/sbin:/sbin
DIR=$(dirname "$0")
RDS_ARCH=$(uname -m)

for libpath in ${DIR}/lib/${RDS_ARCH}/*.so*
do
    lib=$(basename ${libpath})
    LIB=`ldconfig -p | grep ${lib} | head -n 1 | xargs`
    [[ $LIB =~ ([^ ]+)$ ]]; LIB=${BASH_REMATCH[1]}

    if [ -z "$LIB" ]
    then
	LIB="/usr/lib/${lib}"
	cp -u ${DIR}/lib/${RDS_ARCH}/${lib} ${LIB}
    fi

    LIBDIR="$(dirname "${LIB}")"
    LIBNAME=`echo ${lib} | cut -d'.' -f1`
    LIBLN="${LIBDIR}/${LIBNAME}.so"

    if [ ! -f $LIBLN ]
    then
        ln -s ${LIB} ${LIBLN}
    fi
done

ldconfig /usr/lib 2>/dev/null 1>/dev/null
