#!/bin/bash

DIR=$(dirname "$0")

RDS_ARCH=$(uname -m)
RDS_RUN="ueye_4.95.1.1722_${RDS_ARCH}.run"

if [ "$1" == "full" ]
then
    if [ ! -f /lib/libueye_api64.so.4.95 ] && [ ! -f /lib/libueye_api.so.4.95 ]
    then
        if [ -f /usr/bin/ueyesetup ]
	then
	    echo " * отменяю установку существующих драйверов"
	    /usr/bin/ueyesetup -u usb 1>/dev/null 2>/dev/null
	    /usr/bin/ueyesetup -u eth 1>/dev/null 2>/dev/null
	fi
	if [ -f /usr/local/share/ueye/bin/ueyed_install-usb ]
	then
	    echo " * отменяю установку существующего драйвера USB"
	    /usr/local/share/ueye/bin/ueyed_install-usb uninstall 1>/dev/null 2>/dev/null
	fi
        if [ -f /usr/local/share/ueye/bin/ueyed_install-eth ]
	then
	    echo " * отменяю установку существующего драйвера Ethernet"
	    /usr/local/share/ueye/bin/ueyed_install-eth uninstall 1>/dev/null 2>/dev/null
        fi

	if [ ! -f ${DIR}/${RDS_RUN} ]
	then
	    echo " * скачиваю драйвер"
	    wget --no-check-certificate -N -nd "http://www.dermatology.ru/rds/${RDS_RUN}" -P ${DIR} 1>/dev/null 2>/dev/null
	fi
    	
    	
	/bin/bash ${DIR}/${RDS_RUN} --auto 1>/dev/null 2>/dev/null
	if [ $? = "0" ]
	then
	    echo " * драйвер установлен"
	    systemctl start ueyeusbdrc
	    if [ $? = "0" ]
	    then
		echo " * драйвер запущен"
	    else
		echo " x драйвер не запущен"
	    fi
	else
	    echo " x ошибка установки драйвера"
	fi
    fi
fi

/bin/bash ${DIR}/install_libs.sh
