#!/bin/bash

MakeRuleName()
{
    local FILE

    FILE=`echo $1 | awk '{print tolower($0)}'`

    eval "$2='/etc/udev/rules.d/80-drivers-mvs-$FILE.rules'"
}

CreateRuleFile()
{
    # Depending on the version of udev, we need to generate different type of files for the rules @#$@#$@
    VERSION_UDEV=`udevadm --version`
    [[ "${VERSION_UDEV}" =~ ^[0-9]+ ]]
    VERSION_UDEV="${BASH_REMATCH[0]}"
    if [ $VERSION_UDEV -gt 147 ]; then

> $FILENAME
cat > $1 <<__END__
ACTION=="add", SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTRS{idVendor}=="$2", MODE="0666", GROUP="plugdev"
__END__

    else

> $FILENAME
cat > $1 <<__END__
SUBSYSTEM=="usb", SYSFS{idVendor}=="$2", MODE="0666"
__END__

    fi
}

Add()
{
    local FILENAME

    if [ ! -d "/etc/udev/rules.d" ]; then
        echo "Unable to find the folder that contains the rules (/etc/udev/rules.d)."
        exit 3
    fi
    if ! which udevadm >/dev/null 2>&1; then
        echo "Unable to find the udevadm tool to retrieve the current version of udev that is"
        echo "installed on this distribution." 
        echo "You must add the rule manually."
        exit 3
    fi
 
    MakeRuleName "$1" FILENAME
    echo " * adding rules for vendor ID $1."

    # Delete any existing rules with this name first
    rm -f $FILENAME

    # Create the new rule file
    CreateRuleFile "$FILENAME" "$1"
    # Set the permission to the files
    chmod u=rw,g=r,o=r $FILENAME

    # Reload the rules for the usb subsystem
    udevadm trigger --action=add --subsystem-match=usb --attr-match idVendor="$1"
    echo " * $FILENAME created"
}

Remove()
{
    local FILENAME

    if [ -d "/etc/udev/rules.d" ]; then

        MakeRuleName "$1" FILENAME
        echo "Removing the rules for vendor ID $1."
        rm -f $FILENAME

        if which udevadm >/dev/null 2>&1; then
            udevadm trigger --action=change --subsystem-match=usb --attr-match idVendor="$1"
        fi

        echo "The rules for vendor ID $1 have been removed."
    fi
}


VENDORID=""
for i in $*
do
    case $i in        
        --add=0x*)
            VENDORID=0x${i#*=} 
            ACTION="add"
            ;; 
        --add=0X*)
            VENDORID=0X${i#*=} 
            ACTION="add"
            ;; 
        --add=*)
            VENDORID=${i#*=} 
            ACTION="add"
            ;; 
        --add)
            VENDORID=""
            ACTION="add"
            ;; 
        --remove=0x*)
            VENDORID=0x${i#*=} 
            ACTION="remove"
            ;; 
        --remove=0X*)
            VENDORID=0X${i#*=} 
            ACTION="remove"
            ;; 
        --remove=*)
            VENDORID=${i#*=} 
            ACTION="remove"
            ;;  
        --remove)
            VENDORID=""
            ACTION="remove"
            ;;
        *)
            exit 1
	    ;;
    esac
done

if echo "$VENDORID" | grep -qE ^[0-9A-Fa-f]{4}$; then

if [ "$ACTION" = "add" ]; then
    Add $VENDORID
elif [ "$ACTION" = "remove" ]; then
    Remove $VENDORID
elif [ "$ACTION" = "removeall" ]; then
    RemoveAll
fi

fi
